import 'package:flutter/material.dart';
import 'package:flutter_animate/flutter_animate.dart';
import 'package:flutter_spinkit/flutter_spinkit.dart';
import 'package:flutter_widget_from_html/flutter_widget_from_html.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_images.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/controller/nominee/nominee_controller.dart';
import 'package:viserpay/data/controller/savings/savings_history_controller.dart';
import 'package:viserpay/data/model/reward/reward_response_model.dart';
import 'package:viserpay/data/model/savings/savings_response_model.dart';
import 'package:viserpay/view/components/text-form-field/customPinText.dart';

class CloseAccountBottomSheet extends StatelessWidget {
  const CloseAccountBottomSheet({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SavingsHistoryController>(builder: (controller) {
      return Container(
        width: double.infinity,
        padding: EdgeInsets.symmetric(horizontal: Dimensions.space10, vertical: 5),
        decoration: BoxDecoration(borderRadius: BorderRadius.circular(Dimensions.largeRadius), color: MyColor.colorWhite),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Align(
              alignment: Alignment.topRight,
              child: GestureDetector(onTap: () => Get.back(), child: Icon(Icons.close)),
            ),
            SizedBox(height: Dimensions.space10),
            Text(
              "You want to close this savings account ?".tr,
              style: regularDefault.copyWith(fontSize: 18),
              textAlign: TextAlign.center,
              overflow: TextOverflow.ellipsis,
              maxLines: 2,
            ),
            SizedBox(height: Dimensions.space30),
            CustomPinField(
              onChanged: (p) {
                MyUtils.vibrate();
              },
              controller: controller.pinController,
              needOutlineBorder: true,
              labelText: "",
              hintText: MyStrings.enterYourPIN,
              isShowSuffixIcon: true,
              textInputType: TextInputType.number,
              inputAction: TextInputAction.done,
              prefixIcon: const SizedBox(
                width: 22,
                height: 22,
                child: Padding(
                  padding: EdgeInsets.all(8.0),
                  child: Icon(
                    Icons.lock,
                    color: MyColor.primaryColor,
                  ),
                ),
              ),
              suffixWidget: GestureDetector(
                onTap: () {},
                child: const SizedBox(
                  width: 22,
                  height: 22,
                  child: Padding(padding: EdgeInsets.all(5.0), child: Icon(Icons.arrow_right_alt_sharp, color: MyColor.primaryColor)),
                ),
              ),
              onSubmit: () {},
            ),
            SizedBox(height: Dimensions.space20),
            Text(
              MyStrings.savingRemoveTitle.tr,
              style: lightDefault.copyWith(),
              textAlign: TextAlign.center,
            ),
            SizedBox(height: Dimensions.space40),
            Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                GestureDetector(
                  onTap: () => Get.back(),
                  child: Container(
                    padding: EdgeInsets.symmetric(horizontal: 30, vertical: 8),
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(20),
                      //  border: Border.all(color: MyColor.primaryColor),
                      color: MyColor.colorBlack,
                    ),
                    child: Text(MyStrings.no.tr, style: regularDefault.copyWith(color: MyColor.colorWhite)),
                  ),
                ),
                SizedBox(width: Dimensions.space20),
                GestureDetector(
                  onTap: () {
                    Get.back();
                    controller.closeDPS();
                  },
                  child: Container(
                    padding: EdgeInsets.symmetric(horizontal: 30, vertical: 8),
                    decoration: BoxDecoration(borderRadius: BorderRadius.circular(20), color: MyColor.primaryColor),
                    child: Text(MyStrings.yes.tr, style: regularDefault.copyWith(color: MyColor.colorWhite)),
                  ),
                ),
              ],
            ),
            SizedBox(height: Dimensions.space15),
          ],
        ),
      );
    });
  }
}
